(() => {
    const { FormControlController, RentecLitElement } = window;

    class RentecFormElement extends RentecLitElement {
        static properties = {
            ...super.properties,

            name: { type: String, reflect: true },
            value: {},
            disabled: { type: Boolean, reflect: true },
            required: { type: Boolean, reflect: true },
            hideRequired: { type: Boolean, attribute: 'hide-required' },
            errors: { type: Array },
            help: { type: String, reflect: true },
            label: { type: String, reflect: true },
            placeholder: { type: String },
        }
        
        static options = {
            detectSlots: true,
        }

        get submittable() { return !this.disabled; }
        get submitValue() { return this.value; }
        get visibleValue() { return this.value; }

        constructor() {
            super();
            this.value = '';
            this.errors = [];
        }

        connectedCallback() {
            super.connectedCallback();
            this.formController = new FormControlController(this);
        }
        
        clear() {
            this.value = '';
        }
        
        checkValidity() {
            throw new Error('Not implemented');
        }

        reportValidity() {
            throw new Error('Not implemented');
        }
        _reportValidity(cb) {
            this.errors = [];
            cb();
            
            if (this.errors.length) {
                this.dispatchEvent(new CustomEvent('report-validity-error', {
                    bubbles: true,
                }));
            }
            
            return !this.errors.length;
        }
        
        triggerSubmit() {
            const canceled = !this.dispatchEvent(new CustomEvent('control-submit', { bubbles: true, cancelable: true }));
            if (!canceled) {
                this.formController.submitForm();
            }
        }
        
        _checkRequiredValuePresent() {
            if (this.required) {
                if (Array.isArray(this.value)) {
                    return !!this.value.length;
                } else {
                    // Treat falsy values such as false or 0 as non-empty. Only treat empty string or null/undefined as empty.
                    return this.value !== '' && this.value != null;
                }
            }
            return true;
        }
        
        _reportRequiredValuePresent() {
            if (!this._checkRequiredValuePresent()) {
                this.errors = ['Required'];
            }
        }
    }

    window.RentecFormElement = RentecFormElement;
})();
