/**
 * Check user's browser to see if their browser is unsupported, and display a notification if it is unsupported.
 * Load as early as possible in the document's <head>.
 * NOTE: Make this file as compatible as possible with old browsers.
 */
window.BrowserSupport = (function(options) {
	var isTesting = sessionStorage && sessionStorage.getItem('browser-support-testing');
	
	var isSupported = false;
	var canShowUnsupportedNotification = !options.showUnsupportedNotification || isTesting;
	var parsed = {};
	
	// More info available in RDS documentation.
	var defaultSupportedBrowsers =  {
		// https://caniuse.com/mdn-javascript_operators_optional_chaining
		// Application uses optional chaining. Supporting this feature should be enough to cover other required features.
		desktop: {
			chrome: '>=80',
			edge: '>=80',
			firefox: '>=74',
			opera: '>=67',
			safari: '>=15.4',
			samsung_internet: '>=13', // some tablets report themselves as desktop.
		},
		tablet: {
			iOS: {
				safari: '>=15.4',
			},
			android: {
				chrome: '>=80',
				firefox: '>=74',
				samsung_internet: '>=13',
			},
		},
		mobile: {
			iOS: {
				safari: '>=15.4',
			},
			android: {
				chrome: '>=80',
				firefox: '>=74',
				samsung_internet: '>=13',
			},
		},
		
		// fallbacks in case platform not available.
		chrome: '>=80',
		edge: '>=80',
		firefox: '>=74',
		opera: '>=67',
		safari: '>=15.4',
		samsung_internet: '>=13',
	};
	
	try {
		var browser = bowser.getParser(window.navigator.userAgent);
		parsed = browser.parsedResult;
		isSupported = browser.satisfies(options.supportedBrowsers || defaultSupportedBrowsers);
		// On iOS, identify support based on iOS version, as all iOS browsers use the same WebKit version on the OS.
		if (parsed.os.name === 'iOS') {
			isSupported = parsed.os.version > (options.supportedIos || '15.4');
		}
	} catch(e) {}
	
	if (isTesting || !isSupported) {
		// Swallow all errors as they're most likely browser-related errors. Only care about errors coming from browsers
		// we officially support.
		window.onerror = function() {
			return false;
		};
		
		if (canShowUnsupportedNotification) {
			window.addEventListener('load', function() {
				showUnsupportedNotification();
			});
		}
	}
	
	function showUnsupportedNotification() {
		window.globalNotification.createError('<b>Your browser is outdated or not supported</b>. This website may no longer function properly. <b>Please update to the <a href="./Home.action?support=true" style="color: white; text-decoration: underline;">latest version of a major browser.</a></b>');
	}
	
	return {
		isSupported: function() {
			return !isTesting && isSupported;
		},
		parsedBrowser: parsed,
	}
})(window.BrowserSupportOptions || {});
