(function() {
	window.addEventListener('DOMContentLoaded', function() {
		if (document.querySelector('#login-bg-image').getBoundingClientRect().width) {
			const image = new Image();
			image.addEventListener('load', function() {
				const el = document.querySelector('#login-bg-image');
				el.style.opacity = '0';
				el.style.backgroundImage = 'url(' + image.src + ')';
				window.requestAnimationFrame(function() {
					setTimeout(function() {
						el.style.transition = 'opacity 2s';
						el.style.opacity = '1';
					});
				});
			});
			image.src = './img/login-bg-tinted.min.jpg';
		}
	});
	
	j(function() {
		// Focus the field the user will likely input first.
		const usernameEl = document.querySelector('#username');
		const passwordEl = document.querySelector('#password');
		if (usernameEl.value === '') {
			usernameEl.focus();
		} else {
			passwordEl.focus();
		}
		
		// If the user still has the page open after 15m, reload the page to prevent the CSRF token from expiring (or acquire a new one if it already expired)
		const pageLoadTime = new Date().getTime();
		setInterval(function() {
			if (new Date().getTime() - pageLoadTime >= 900000) {
				window.location.reload();
			}
		}, 1000);
	});
})()