(function() {
	window.addEventListener('DOMContentLoaded', function() {
		document.querySelectorAll('form').forEach(function(formEl) {
			formEl.addEventListener('submit', function(e) {
				if (formEl.dataset.dynamic) { return; }
				
				if (formEl.dataset.submitting === 'submitting') {
					e.preventDefault();
					e.stopImmediatePropagation();
					return false;
				}
				
				formEl.dataset.submitting = 'submitting';
				setTimeout(function() {
					// Disabled controls do not send their values, so delay disabling the submit button until after
					// the form is actually submitted.
					if (formEl.dataset.submitting) {
						const submitButton = formEl.querySelector('button[type="submit"]');
						if (submitButton) {
							submitButton.disabled = true;
						}
					}
				});
				
				window.addEventListener('pageshow', function() {
					// Make sure the form is submittable if the user back-navigates to this page after submitting something.
					delete formEl.dataset.submitting;
					const submitButton = formEl.querySelector('button[type="submit"]');
					if (submitButton) {
						submitButton.disabled = false;
					}
				});
			});
		});
	});
})();