(() => {
    const { RentecLitElement, lit } = window;
    const { html, css } = lit;
    
    (class RentecTooltip extends RentecLitElement {
        static properties = {
            ...super.properties,
            content: { type: String },
            delay: { type: Number },
            show: { type: Boolean },
        }
        
        static styles = [
            super.styles,
            css`
				:host {
                    --r-tooltip-color-bg: var(--tooltip-color-bg);
                    --r-tooltip-color-border: var(--tooltip-color-border, var(--tooltip-color-bg));
                    
					display: contents;
				}

                r-popup {
                    --r-popup-z-index: var(--z-popover);
                    --r-popup-arrow-color: var(--r-tooltip-color-bg);
                    --r-popup-arrow-border-color: var(--r-tooltip-color-border);
                }
                
                .body {
                    max-width: var(--space-s-3);
                    background: var(--r-tooltip-color-bg);
                    border: 1px solid var(--r-tooltip-color-border);
                    box-shadow: var(--shadow-md);
                    color: var(--tooltip-color-fg);
                    font-family: var(--ff-primary);
                    font-size: var(--fs-f5);
                    line-height: var(--fs-f5-lh);
                    padding: var(--space-2) var(--space-3);
                }
			`
        ]
        
        render() {
            return html`
                <r-popup ?show="${this.show}" tip placement="top" trigger="hover" delay="${this.delay}">
                    <slot></slot>
                    <div slot="content" class="body" part="body">
                        <slot name="content">${this.content}</slot>
                    </div>
                </r-popup>
			`;
        }
    }).define('r-tooltip');
    
    (class RentecTooltipTextTrigger extends RentecLitElement {
        static styles = [
            super.styles,
            css`
				:host {
					display: inline-block;
				}
			`
        ]
        
        render() {
            return html`
                <div style="display: inline; text-decoration: underline; text-decoration-style: dotted; cursor: default;" tabindex="0">
                    <slot></slot>
                </div>
			`;
        }
    }).define('r-tooltip-text-trigger');
})();
