/* This script was compiled from an ESM version - do not modify directly! */
var rodash = (function () {
	'use strict';

	// Rentec Lodash
	// https://lodash.com
	// https://youmightnotneed.com/lodash/

	var rodash = {
		debounce(func, wait, immediate) {
			let timeout;
			return (...args) => {
				const callNow = immediate && !timeout;
				clearTimeout(timeout);
				timeout = setTimeout(() => {
					timeout = null;
					if (!immediate) func.apply(this, args);
				}, wait);
				if (callNow) func.apply(this, args);
			};
		},
		/**
		 * Gets the value of a object property given a period-delimited string or array path
		 * Source: https://youmightnotneed.com/lodash/
		 * @param obj
		 * @param path
		 * @param defValue
		 * @returns {undefined|*}
		 */
		get(obj, path, defValue) {
			// If path is not defined or it has false value
			if (!path) return undefined;
			// Check if path is string or array. Regex : ensure that we do not have '.' and brackets.
			// Regex explained: https://regexr.com/58j0k
			const pathArray = Array.isArray(path) ? path : path.match(/([^[.\]])+/g);
			// Find value
			const result = pathArray.reduce((prevObj, key) => prevObj && prevObj[key], obj);
			// If found value is undefined return default value; otherwise return the value
			return result === undefined ? defValue : result;
		},
		/**
		 * Sets the value of a object property given a period-delimited string or array path
		 * Source: https://youmightnotneed.com/lodash/
		 * @param obj
		 * @param path
		 * @param value
		 * @param isDefineProperty - used for defining a getter/setter on the obj
		 */
		set(obj, path, value, isDefineProperty = false) {
			// Regex explained: https://regexr.com/58j0k
			const pathArray = Array.isArray(path) ? path : path.match(/([^[.\]])+/g);
			
			pathArray.reduce((acc, key, i) => {
				if (acc[key] === undefined) acc[key] = {}
				if (i === pathArray.length - 1) {
					if (isDefineProperty) {
						Object.defineProperty(acc, key, value);
						return acc;
					}
					acc[key] = value;
				}
				
				return acc[key];
			}, obj);
		},
		/**
		 * Execute a function for every object property.
		 * The function is passed the path of the property as a period-delimited string.
		 * @param obj
		 * @param cb
		 */
		parseObj(obj, cb) {
			this._parseObj(obj, null, cb);
		},
		_parseObj(obj, currKey, cb) {
			if (Array.isArray(obj)) {
				cb(currKey);
				return;
			}
			for (const key in obj) {
				const newKey = currKey ? `${currKey}.${key}` : key;
				// Only parse object that has keys - otherwise a property set to {} is skipped
				if (obj[key] !== null && typeof obj[key] === 'object' && Object.keys(obj[key]).length > 0) {
					this._parseObj(obj[key], newKey, cb);
				}
				else if (Object.prototype.hasOwnProperty.call(obj, key)) {
					cb(newKey);
				}
			}
		},
		kebabToCamelCase(s) {
			return s.replace(/-./g, x=>x.toUpperCase()[1]);
		},
		kebabCase(s) {
			return s
				.match(/[A-Z]{2,}(?=[A-Z][a-z]+[0-9]*|\b)|[A-Z]?[a-z]+[0-9]*|[A-Z]|[0-9]+/g)
				.map(x => x.toLowerCase())
				.join('-');
		},
		
		isNil(value) {
			return value === undefined || value === null;
		},
		omitBy(obj, check) {
			const reObj = { ...obj };
			Object.entries(reObj).forEach(([key, value]) => check(value) && delete reObj[key]);
			return reObj;
		},
		chunk(arr, chunkSize = 1, cache = []) {
			const tmp = [...arr];
			if (chunkSize <= 0) return cache
			if (chunkSize < 1) return [tmp];
			// Handle decimals
			while (tmp.length) cache.push(tmp.splice(0, Math.ceil(chunkSize)));
			return cache
		},
		
		async isElementFullyInView(el) {
			return new Promise(resolve => {
				const intersectionObserver = new IntersectionObserver((entries) => {
					intersectionObserver.disconnect();
					
					// If intersectionRatio is < 1, the element is not completely in view.
					if (entries[0].intersectionRatio < 1) {
						resolve(false);
					} else {
						resolve(true);
					}
				});
				intersectionObserver.observe(el);
			});
		},
	};

	return rodash;

})();
